@extends('layouts.master')

@section('title')
    Daftar Penjualan
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Daftar Penjualan</li>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                        <th width="5%">No</th>
                        <th>Tanggal</th>
                        
                        <th>Total Item</th>
                        {{-- <th>Total Harga</th> --}}
                        {{-- <th>Diskon</th> --}}
                        <th>Total Bayar</th>
                        <th>Tipe</th>
                        <th>Staff</th>
                        <th width="15%"><i class="fa fa-cog"></i></th>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>

@includeIf('penjualan.detail')
@includeIf('penjualan.catatan')
@endsection

@push('scripts')
<script>
    let table, table1, table2;

    $(function () {
        table = $('.table-penjualan').DataTable({
            processing: true,
            autoWidth: false,
            ajax: {
                url: '{{ route('penjualan.data') }}',
            },
            columns: [
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                {data: 'tanggal'},
                
                {data: 'total_item'},
                // {data: 'total_harga'},
                // {data: 'diskon'},
                {data: 'bayar'},
                {data: 'jenis_pembayaran'},
                {data: 'id_user'},
                {data: 'aksi', searchable: false, sortable: false},
            ]
        });

        table1 = $('.table-detail').DataTable({
            processing: true,
            bSort: false,
            columns: [
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                {data: 'kode_produk'},
                {data: 'nama_produk'},
                {data: 'harga_jual'},
                {data: 'jumlah'},
                {data: 'subtotal'},
            ]
        });
         table2 = $('.table-detail2').DataTable({
            processing: true,
            bSort: false,
           searching:false,
           "lengthChange": false,
            "info": false,
            "bPaginate": false,
            columns: [
               
                {data: 'catatan'},   
                ]
            });
    });

    function showDetail(url) {
        $('#modal-detail').modal('show');

        table1.ajax.url(url);
        table1.ajax.reload();
    }
    function showDetail2(url) {
        $('#modal-detail2').modal('show');

        table2.ajax.url(url);
        table2.ajax.reload();
    }
    function deleteData(url) {
        if (confirm('Yakin ingin menghapus data terpilih?')) {
            $.post(url, {
                    '_token': $('[name=csrf-token]').attr('content'),
                    '_method': 'delete'
                })
                .done((response) => {
                    table.ajax.reload();
                })
                .fail((errors) => {
                    alert('Tidak dapat menghapus data');
                    return;
                });
        }
    }
</script>


@endpush