@extends('layouts.master')

@section('title')
   
@endsection

@push('css')
<link rel="stylesheet" href="{{ asset('/AdminLTE-2/bower_components/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css') }}">
@endpush

@section('breadcrumb')
    @parent
    <li class="active">Laporan</li>
@endsection
@section('content')
<body onload="window.print();">
     <h4>Laporan Detil Tanggal {{ tanggal_indonesia($tanggalAkhir, false) }} ({{auth()->user()->name}})</h4>
{{-- <a href="{{route('laporanauth.cetak2')}}" target="_blank" class="btn btn-xs btn-primary btn-flat"><i class="fas fa-print"></i></a> --}}
  <div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                 <h4>TRANSAKSI MEMBER</h4>
            </div>
            <div class="box-body table-responsive">
                @if(auth()->user()->level === 1 )
                    <table class="table table-stiped table-bordered">
                            <thead>
                                <th width="5%">No</th>
                                <th>Member</th>
                                <th>Status</th>
                                <th>Harga</th>
                                <th>User</th>
                                {{-- <th>Opsi</th> --}}
                            </thead>
                            <tbody>
                            @php 
                        $no = 1;
                        foreach($total_untuk_admin as $sp){
                            @endphp
                                <tr> 
                                    <td>{{$no}}</td>   
                                    <td>{{$sp->nama}}</td>
                                    <td>{{$sp->status}}</td>
                                    <td>@currency($sp->total)</td>
                                    <td>{{$sp->role}}</td>
                                </tr> 
                            @php
                            $no++;
                        }
                            @endphp 
                            <tr>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td style="font-weight: bold;">Total: @currency($total_member_untuk_admin)</td>
                            </tr>
                            </tbody>
                    </table>
                @elseif(auth()->user()->level === 2 )
                    <table class="table table-stiped table-bordered">
                                <thead>
                                    <th width="5%">No</th>
                                    <th>Member</th>
                                    <th>Status</th>
                                    <th>Harga</th>
                                </thead>
                                <tbody>
                                @php 
                            $no = 1;
                            foreach($total as $sp){
                                @endphp
                                    <tr> 
                                        <td>{{$no}}</td>   
                                        <td>{{$sp->nama}}</td>
                                        <td>{{$sp->status}}</td>
                                        <td>@currency($sp->total)</td>
                                    </tr> 
                                @php
                                $no++;
                            }
                                @endphp 
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td style="font-weight: bold;">Total: @currency($total_member)</td>
                                </tr>
                                </tbody>
                    </table>
                    @endif 
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                 <h4>PENJUALAN</h4>
            </div>
            <div class="box-body table-responsive">
                @if(auth()->user()->level === 1 )
                   <table class="table table-stiped table-bordered">
                    <thead>
                        <th width="5%">No</th>
                        <th style="text-align: center;">Produk</th>
                        <th style="text-align: center;">Qty</th>
                        <th style="text-align:center;">Harga</th>
                        <th style="text-align: center;">Jumlah</th>
                    </thead>
                    <tbody>
                       @php 
                $no = 1;
                foreach (collect($food_admin)->unique('id_produk') as $k){
               
                    @endphp
                        <tr> 
                            <td>{{$no}}</td>   
                            <td>{{$k->nama_produk}}</td>
                            <td style="text-align: center;">{{$k->count}}</td>
                            <td style="text-align: right;">@currency($k->harga_jual) </td>
                            <td style="text-align: right;">@currency($k->harga_jual * $k->count)</td> 
                        </tr> 
                        
                    @php
                    $no++;
                }
                    @endphp 
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="text-align: right; font-weight: bold;">Total: @currency($total_food_admin)</td>
                    </tr>
                    </tbody>
                </table>
                @elseif(auth()->user()->level === 2)
                <table class="table table-stiped table-bordered">
                    <thead>
                        <th width="5%">No</th>
                        <th style="text-align: center;">Produk</th>
                        <th style="text-align: center;">Qty</th>
                        <th style="text-align:center;">Harga</th>
                        <th style="text-align: center;">Jumlah</th>
                    </thead>
                    <tbody>
                       @php 
                $no = 1;
                foreach (collect($food)->unique('id_produk') as $k){
               
                    @endphp
                        <tr> 
                            <td>{{$no}}</td>   
                            <td>{{$k->nama_produk}}</td>
                            <td style="text-align: center;">{{$k->count}}</td>
                            <td style="text-align: right;">@currency($k->harga_jual) </td>
                            <td style="text-align: right;">@currency($k->harga_jual * $k->count)</td> 
                        </tr> 
                        
                    @php
                    $no++;
                }
                    @endphp 
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="text-align: right; font-weight: bold;">Total: @currency($total_food)</td>
                    </tr>
                    </tbody>
                </table>
                    @endif 
            </div>
        </div>
    </div>
</div>
   

<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
               <h4>PENGELUARAN</h4>
            </div>
            <div class="box-body table-responsive">
                 @if(auth()->user()->level === 1)
                <table class="table table-stiped table-bordered">
                    <thead>
                        <th width="5%">No</th>
                        <th style="text-align: center;">Item</th>
                        <th style="text-align: center;">Qty</th>
                        <th style="text-align:center;">Harga</th>
                        <th style="text-align: center;">Jumlah</th>
                    </thead>
                    <tbody>
                       @php 
                $no = 1;
                foreach($item_admin as $o){
                    @endphp
                        <tr> 
                            <td>{{$no}}</td>   
                            <td>{{$o->nama_barang}}</td>
                            <td style="text-align: center;">{{$o->qty}}</td>
                            <td style="text-align: right;">@currency($o->harga)</td>
                            <td style="text-align: right;">@currency($o->total)</td>
                        </tr> 
                        
                    @php
                    $no++;
                }
                    @endphp 
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="text-align: right; font-weight: bold;">Total: @currency($total_metune_admin)</td>
                        
                    </tr>
                    {{-- <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="text-align: right; font-weight: bold;">Balance:@currency($total_food_admin + $total_member_untuk_admin - $total_metune_admin)</td>
                    </tr> --}}
                    </tbody>
                </table>


                @elseif(auth()->user()->level === 2)
                <table class="table table-stiped table-bordered">
                    <thead>
                        <th width="5%">No</th>
                        <th style="text-align: center;">Item</th>
                        <th style="text-align: center;">Qty</th>
                        <th style="text-align:center;">Harga</th>
                        <th style="text-align: center;">Jumlah</th>
                    </thead>
                    <tbody>
                       @php 
                $no = 1;
                foreach($item as $o){
                    @endphp
                        <tr> 
                            <td>{{$no}}</td>   
                            <td>{{$o->nama_barang}}</td>
                            <td style="text-align: center;">{{$o->qty}}</td>
                            <td style="text-align: right;">@currency($o->harga)</td>
                            <td style="text-align: right;">@currency($o->total)</td>
                        </tr> 
                        
                    @php
                    $no++;
                }
                    @endphp 
                    <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="text-align: right; font-weight: bold;">Total: @currency($total_metune)</td>
                        
                    </tr>
                    {{-- <tr>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="text-align: right; font-weight: bold;">Balance: @currency(($total_food + $total_member) - $total_metune )</td>
                    </tr> --}}
                    </tbody>
                </table>
                @endif
            </div>
        </div>
    </div>

    
</div>


<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                 @if(auth()->user()->level === 1 )
                    <h2 style="font-weight:bold;">BALANCE : @currency($total_food_admin + $total_member_untuk_admin - $total_metune_admin)</h2>
            </div>
            

                
                @elseif(auth()->user()->level === 2)
                
                        <H2 style="font-weight: bold;">Balance: @currency(($total_food + $total_member) - $total_metune )</H2>

        
                @endif
            </div>
        </div>
    </div>

    
</div>
</body>
@includeIf('laporan.form')
@endsection

@push('scripts')
<script src="{{ asset('/AdminLTE-2/bower_components/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js') }}"></script>
<script>
  

        $('.datepicker').datepicker({
            format: 'yyyy-mm-dd',
            autoclose: true
        });
    });

    function updatePeriode() {
        $('#modal-form').modal('show');
    }
</script>
@endpush